using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Outbound_OpenInterface_Test_App.OutboundCampaignWS;
using System.Web.Services.Protocols;

namespace Outbound_OpenInterface_Test_App
{
  public partial class Close_Contact : Form
  {
    OWCampaigns This_Campaign_List;
    int This_Selected_Index;

    public Close_Contact(OWCampaigns Campaign_List, int Selected_Index)
    {
      InitializeComponent();
      This_Campaign_List = Campaign_List;
      This_Selected_Index = Selected_Index;
      Campaign_Name_Field.Text = This_Campaign_List.CampaignList[This_Selected_Index].Name;
    }

    /// <summary>
    /// Clsoe the contact by contact id
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Close_By_ID_Button_Click(object sender, EventArgs e)
    {
      try
      {
        //get a valid dis code with no retry count
        long DisID = 0;
        long Campaign_ID = This_Campaign_List.CampaignList[This_Selected_Index].ID;

        for(int i = 0; i < This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes.Length; i++)
        {
          if(This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].Name == "Completed")
          {
            DisID = This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].Id;
            break;
          }
          else if((This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].MaxRetryCount <= 0) &&
            (This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].Name != "Re-Schedule Call") &&
            (This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].Name != "Do Not Call"))
          {
            DisID = This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].Id;
          }
        }

        OutboundContactWS.OutboundContactWS contInvoke = new OutboundContactWS.OutboundContactWS();
        long returnVal = contInvoke.CloseContact(System.Convert.ToInt32(Campaign_ID), System.Convert.ToInt32(Contact_ID_Field.Text), Custom_Name_Field.Text, Custom_Value_Field.Text, false, "Closed by 3rd Part App", DisID, true, GlobalDef.getInstance().MySessionKey);
        if(returnVal == 0)
          Message_Label.Text = "Contact Closed";
        else
          Message_Label.Text = "Contact Not Closed - Error";
      }
      catch
      {
        Message_Label.Text = "Error Finding Contact";
      }
    }

    /// <summary>
    /// close the contact by custom field
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Close_By_CF_Button_Click(object sender, EventArgs e)
    {
      try
      {

        //get a valid dis code with no retry count
        long DisID = 0;
        long Campaign_ID = This_Campaign_List.CampaignList[This_Selected_Index].ID;

        for(int i = 0; i < This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes.Length; i++)
        {
          if(This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].Name == "Completed")
          {
            DisID = This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].Id;
            break;
          }
          else if((This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].MaxRetryCount <= 0) &&
            (This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].Name != "Re-Schedule Call") &&
            (This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].Name != "Do Not Call"))
          {
            DisID = This_Campaign_List.CampaignList[This_Selected_Index].DispositionCodes[i].Id;
          }
        }

        OutboundContactWS.OutboundContactWS contInvoke = new OutboundContactWS.OutboundContactWS();
        long returnVal = contInvoke.CloseContact(System.Convert.ToInt32(Campaign_ID), System.Convert.ToInt32(Contact_ID_Field.Text), Custom_Name_Field.Text, Custom_Value_Field.Text, true, "Closed by 3rd Part App", DisID, true, GlobalDef.getInstance().MySessionKey);
        if(returnVal == 0)
          Message_Label.Text = "Contact Closed";
        else
          Message_Label.Text = "Contact Not Closed - Error";
      }
      catch
      {
        Message_Label.Text = "Error Finding Contact";
      }
    }
  }
}